export declare enum Bundler {
    Turbopack = 0,
    Webpack = 1,
    Rspack = 2
}
/**
 * Parse the bundler arguments and potentially sets the `TURBOPACK` environment variable.
 *
 * NOTE: rspack is configured via next config which is chaotic so it is possible for this to be overridden later.
 *
 * @param options The options to parse.
 * @returns The bundler that was configured
 */
export declare function parseBundlerArgs(options: {
    turbo?: boolean;
    turbopack?: boolean;
    webpack?: boolean;
}): Bundler;
/**
 * Finalize the bundler based on the config.
 *
 * Rspack is configured via next config by setting an environment variable (yay, side effects)
 * so this should only be called after parsing the config.
 */
export declare function finalizeBundlerFromConfig(fromOptions: Bundler): Bundler;
