declare const originalSetImmediate: typeof setImmediate;
export { originalSetImmediate as unpatchedSetImmediate };
/**
 * **WARNING: This function changes the usual behavior of the event loop!**
 * **Be VERY careful about where you call it.**
 *
 * Starts capturing calls to `setImmediate` to run them as "fast immediates".
 * All calls captured in this way will be executed after the current task
 * (after callbacks from `process.nextTick()`, microtasks, and nextTicks scheduled from microtasks).
 * This function needs to be called again in each task that needs the
 * "fast immediates" behavior.
 *
 * ### Motivation
 *
 * We don't want `setImmediate` to be considered IO in Cache Components.
 * To achieve this in a staged (pre)render, we want to allow immediates scheduled
 * in stage N to run before stage N+1.
 * Since we schedule stages using sequential `setTimeout`, this isn't possible without
 * intercepting `setImmediate` and doing the scheduling on our own.
 * We refer to this as a "fast immediate".
 *
 * Notably, this affects React's `scheduleWork` in render, which uses `setImmediate`.
 * This is desirable -- if async work was scheduled during a stage, then it should
 * get to run before we finish that stage.
 *
 * ### Example
 *
 * ```ts
 * setTimeout(() => {
 *   runPendingImmediatesAfterCurrentTask()
 *   console.log("timeout 1")
 *   setImmediate(() => {
 *     console.log("immediate!!!")
 *   })
 * })
 * setTimeout(() => {
 *   console.log("timeout 2")
 * })
 * ```
 * will print
 *
 * ```
 * timeout 1
 * immediate!!!
 * timeout 2
 * ```
 *
 * instead of the usual order
 * ```
 * timeout 1
 * timeout 2
 * immediate!!!
 * ```
 * > **NOTE**
 * > The above is *most common* order, but it's not guaranteed.
 * > Under some circumstances (e.g. when the event loop is blocked on CPU work),
 * > Node will reorder things and run the immediate before timeout 2.
 * > So, in a sense, we're just making this reordering happen consistently.
 *
 * Recursive `setImmediate` calls will also be executed as "fast immediates".
 * If multiple immediates were scheduled, `process.nextTick()` (and associated microtasks)
 * will be allowed to execute between them.
 * See the unit tests for more examples.
 * */
export declare function DANGEROUSLY_runPendingImmediatesAfterCurrentTask(): void;
/**
 * This should always be called a task after `DANGEROUSLY_runPendingImmediatesAfterCurrentTask`
 * to make sure that everything executed as expected and we're not left in an inconsistent state.
 * Ideally, this wouldn't be necessary, but we're not in control of the event loop
 * and need to guard against unexpected behaviors not forseen in this implementation,
 * so we have to be defensive.
 */
export declare function expectNoPendingImmediates(): void;
