import Link from "next/link";
import Image from "next/image";

const PRIMARY_WHATSAPP_INTEREST =
  "https://wa.me/97455518955?text=Hi%20there%20Im%20interested%20in%20this%20deal";

const FINJAN_WHATSAPP = "https://wa.me/97455518955";

type InvestmentLandingProps = {
  refCode: string | null;
};

export default function InvestmentLanding({ refCode }: InvestmentLandingProps) {
  return (
    <div className="min-h-screen bg-white text-[#7d471e]">
      <div className="mx-auto flex min-h-screen max-w-6xl flex-col px-4 pb-16 pt-8 md:px-8 lg:px-12">
        {/* Top nav / brand */}
        <header className="flex items-center justify-between gap-4 border-b border-slate-200 pb-4">
          <div className="flex items-center gap-3">
            <div className="relative h-16 w-16 flex-shrink-0">
              <Image
                src="/finjan-logo.png"
                alt="Finjan Logo"
                fill
                className="object-contain"
                priority
                sizes="64px"
              />
            </div>
            <div>
              <p className="text-xs font-semibold uppercase tracking-[0.2em] text-[#cda22b]">
                Finjan.vc
              </p>
              <p className="text-sm text-slate-600">
                Private Investment Opportunity
              </p>
            </div>
          </div>
          <div className="hidden items-center gap-3 text-xs font-medium text-[#7d471e] md:flex">
            <span className="rounded-full border border-slate-300 bg-white px-3 py-1">
              Professional Investors Only
            </span>
            {refCode && (
              <span className="rounded-full border border-emerald-300 bg-white px-3 py-1 text-[#cda22b]">
                Personalized Link • Ref: {refCode}
              </span>
            )}
          </div>
        </header>

        {/* Hero */}
        <main className="mt-10 grid flex-1 gap-10 lg:grid-cols-[minmax(0,3fr)_minmax(0,2fr)] lg:items-start">
          <section className="space-y-10">
            <div className="inline-flex items-center gap-2 rounded-full border border-emerald-200 bg-white px-3 py-1 text-xs font-medium text-[#cda22b]">
              <span className="h-1.5 w-1.5 rounded-full bg-white0 animate-pulse" />
              Live Investment Opportunity
            </div>
            <div className="space-y-4">
              <h1 className="text-balance text-4xl font-semibold tracking-tight text-[#7d471e] sm:text-5xl lg:text-6xl">
                Invest in{" "}
                <span className="bg-gradient-to-r from-[#cda22b] via-[#9db47e] to-[#9db47e] bg-clip-text text-transparent">
                  Madak
                </span>
                : Saudi Arabia's First Licensed{" "}
                <span className="bg-gradient-to-r from-[#cda22b] via-[#9db47e] to-[#9db47e] bg-clip-text text-transparent">
                  Fractional Real Estate Platform
                </span>
              </h1>
              <p className="max-w-xl text-pretty text-base text-[#7d471e] sm:text-lg">
                Licensed fractional ownership platform enabling individuals to invest in income-generating real estate starting from SAR 500, with built-in liquidity via a resale marketplace.
              </p>
            </div>
            <div className="flex flex-wrap items-center gap-4">
              <a
                href={PRIMARY_WHATSAPP_INTEREST}
                target="_blank"
                rel="noopener noreferrer"
                className="inline-flex items-center justify-center gap-2 rounded-full bg-emerald-600 px-7 py-3 text-sm font-semibold text-white shadow-lg shadow-emerald-500/30 transition hover:bg-emerald-700"
              >
                Express Interest
              </a>
              <div className="flex flex-col text-xs text-slate-600">
                <span>Direct conversation with Finjan.vc team</span>
                <span className="text-[#7d471e]0">
                  No obligation • WhatsApp-based introduction
                </span>
              </div>
            </div>

            {/* Key Highlights - Visual Cards */}
            <div className="grid gap-4 rounded-2xl border border-slate-200 bg-white p-6 sm:grid-cols-2 lg:grid-cols-4">
              <div className="flex flex-col items-center justify-center rounded-xl border border-emerald-200 bg-white p-4 text-center">
                <div className="text-3xl font-bold text-[#cda22b]">1st</div>
                <div className="mt-1 text-xs text-slate-600">Licensed Platform</div>
                <div className="mt-1 text-[10px] text-[#7d471e]0">In Saudi Arabia</div>
              </div>
              <div className="flex flex-col items-center justify-center rounded-xl border border-slate-200 bg-white p-4 text-center">
                <div className="text-3xl font-bold text-[#7d471e]">SAR 500</div>
                <div className="mt-1 text-xs text-slate-600">Minimum Investment</div>
                <div className="mt-1 text-[10px] text-[#7d471e]0">Accessible Entry</div>
              </div>
              <div className="flex flex-col items-center justify-center rounded-xl border border-slate-200 bg-white p-4 text-center">
                <div className="text-3xl font-bold text-[#7d471e]">100%</div>
                <div className="mt-1 text-xs text-slate-600">Digital Platform</div>
                <div className="mt-1 text-[10px] text-[#7d471e]0">Fully Automated</div>
              </div>
              <div className="flex flex-col items-center justify-center rounded-xl border border-slate-200 bg-white p-4 text-center">
                <div className="text-3xl font-bold text-[#7d471e]">✓</div>
                <div className="mt-1 text-xs text-slate-600">Built-in Liquidity</div>
                <div className="mt-1 text-[10px] text-[#7d471e]0">Resale Marketplace</div>
              </div>
            </div>

            {/* Traction Metrics - Large Visual Stats */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">
                Proven Traction & Growth
              </h2>
              <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
                <div className="relative overflow-hidden rounded-xl border border-emerald-200 bg-white p-5">
                  <div className="text-xs uppercase tracking-[0.2em] text-[#cda22b]">
                    Platform Users
                  </div>
                  <div className="mt-2 text-3xl font-bold text-[#cda22b]">
                    13,000+
                  </div>
                  <div className="mt-1 text-xs text-[#cda22b]/80">
                    Growing user base
                  </div>
                  <div className="absolute -right-4 -top-4 h-20 w-20 rounded-full bg-emerald-200/50 blur-2xl" />
                </div>
                <div className="relative overflow-hidden rounded-xl border border-slate-200 bg-white p-5">
                  <div className="text-xs uppercase tracking-[0.2em] text-slate-600">
                    Active Investors
                  </div>
                  <div className="mt-2 text-3xl font-bold text-[#7d471e]">700+</div>
                  <div className="mt-1 text-xs text-slate-600">
                    Engaged investors
                  </div>
                </div>
                <div className="relative overflow-hidden rounded-xl border border-slate-200 bg-white p-5">
                  <div className="text-xs uppercase tracking-[0.2em] text-slate-600">
                    GMV
                  </div>
                  <div className="mt-2 text-3xl font-bold text-[#7d471e]">
                    SAR 2.6M
                  </div>
                  <div className="mt-1 text-xs text-slate-600">
                    Gross merchandise value
                  </div>
                </div>
                <div className="relative overflow-hidden rounded-xl border border-slate-200 bg-white p-5">
                  <div className="text-xs uppercase tracking-[0.2em] text-slate-600">
                    Retention Rate
                  </div>
                  <div className="mt-2 text-3xl font-bold text-[#7d471e]">60%</div>
                  <div className="mt-1 text-xs text-slate-600">
                    Strong user retention
                  </div>
                </div>
              </div>
            </section>

            {/* Investment Performance - Visual Bar */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">
                Investment Performance
              </h2>
              <div className="rounded-xl border border-slate-200 bg-white p-6">
                <div className="grid gap-6 md:grid-cols-3">
                  <div className="text-center">
                    <div className="text-4xl font-bold text-[#cda22b]">
                      SAR 3.18M
                    </div>
                    <div className="mt-2 text-sm text-slate-600">
                      Raised across 2 premium opportunities
                    </div>
                  </div>
                  <div className="text-center">
                    <div className="text-4xl font-bold text-[#cda22b]">10%</div>
                    <div className="mt-2 text-sm text-slate-600">
                      Returns delivered
                    </div>
                  </div>
                  <div className="text-center">
                    <div className="text-4xl font-bold text-[#cda22b]">1,070+</div>
                    <div className="mt-2 text-sm text-slate-600">
                      Investors participated
                    </div>
                  </div>
                </div>
                <div className="mt-6 flex items-center justify-center gap-2 rounded-lg bg-white px-4 py-2">
                  <span className="text-xs font-medium text-[#cda22b]">
                    ⚡ Fastest opportunity closed in 90 minutes
                  </span>
                </div>
              </div>
            </section>

            {/* Unit Economics - Visual Comparison */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">
                Exceptional Unit Economics
              </h2>
              <div className="grid gap-4 md:grid-cols-2">
                <div className="rounded-xl border border-emerald-200 bg-white p-5">
                  <div className="flex items-center justify-between">
                    <div>
                      <div className="text-xs uppercase tracking-[0.2em] text-[#cda22b]">
                        CAC
                      </div>
                      <div className="mt-1 text-2xl font-bold text-[#cda22b]">
                        SAR 224
                      </div>
                    </div>
                    <div className="text-3xl">📊</div>
                  </div>
                  <div className="mt-3 h-2 overflow-hidden rounded-full bg-slate-200">
                    <div
                      className="h-full bg-gradient-to-r from-emerald-500 to-emerald-600"
                      style={{ width: "45%" }}
                    />
                  </div>
                  <div className="mt-2 text-xs text-slate-600">
                    Low customer acquisition cost
                  </div>
                </div>
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <div className="flex items-center justify-between">
                    <div>
                      <div className="text-xs uppercase tracking-[0.2em] text-slate-600">
                        Marketing Efficiency
                      </div>
                      <div className="mt-1 text-2xl font-bold text-[#7d471e]">17x</div>
                    </div>
                    <div className="text-3xl">🚀</div>
                  </div>
                  <div className="mt-3 h-2 overflow-hidden rounded-full bg-slate-200">
                    <div
                      className="h-full bg-gradient-to-r from-emerald-500 to-cyan-500"
                      style={{ width: "100%" }}
                    />
                  </div>
                  <div className="mt-2 text-xs text-slate-600">
                    SAR 17 raised per SAR 1 spent
                  </div>
                </div>
              </div>
            </section>

            {/* Problem & Solution */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">
                The Problem We Solve
              </h2>
              <div className="grid gap-4 md:grid-cols-2">
                <div className="rounded-xl border border-red-200 bg-white p-5">
                  <div className="mb-3 text-lg">❌</div>
                  <h3 className="text-sm font-semibold text-red-700">
                    For Investors
                  </h3>
                  <ul className="mt-3 space-y-2 text-xs text-[#7d471e]">
                    <li className="flex items-start gap-2">
                      <span className="mt-1">•</span>
                      <span>High capital required to invest in real estate</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="mt-1">•</span>
                      <span>Complex legal and acquisition processes</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="mt-1">•</span>
                      <span>Lack of liquidity and exit options</span>
                    </li>
                  </ul>
                </div>
                <div className="rounded-xl border border-orange-200 bg-white p-5">
                  <div className="mb-3 text-lg">❌</div>
                  <h3 className="text-sm font-semibold text-orange-700">
                    For Developers
                  </h3>
                  <ul className="mt-3 space-y-2 text-xs text-[#7d471e]">
                    <li className="flex items-start gap-2">
                      <span className="mt-1">•</span>
                      <span>Slow property sales cycles (up to 8 months)</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="mt-1">•</span>
                      <span>Cash flow constraints</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span className="mt-1">•</span>
                      <span>Limited access to fast capital</span>
                    </li>
                  </ul>
                </div>
              </div>
            </section>

            {/* Solution */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">Our Solution</h2>
              <div className="rounded-xl border border-emerald-200 bg-white p-6">
                <div className="mb-4 text-2xl">✅</div>
                <div className="grid gap-6 md:grid-cols-2">
                  <div>
                    <h3 className="text-sm font-semibold text-[#cda22b]">
                      For Investors
                    </h3>
                    <ul className="mt-3 space-y-2 text-sm text-[#7d471e]">
                      <li className="flex items-start gap-2">
                        <span className="mt-1 text-emerald-400">✓</span>
                        <span>Invest in real estate instantly starting from SAR 500</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="mt-1 text-emerald-400">✓</span>
                        <span>Earn income from fractional ownership</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="mt-1 text-emerald-400">✓</span>
                        <span>Track performance through mobile platform</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="mt-1 text-emerald-400">✓</span>
                        <span>Exit investments via resale marketplace</span>
                      </li>
                    </ul>
                  </div>
                  <div>
                    <h3 className="text-sm font-semibold text-[#cda22b]">
                      For Developers
                    </h3>
                    <ul className="mt-3 space-y-2 text-sm text-[#7d471e]">
                      <li className="flex items-start gap-2">
                        <span className="mt-1 text-emerald-400">✓</span>
                        <span>Faster fundraising</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="mt-1 text-emerald-400">✓</span>
                        <span>Reduced sales cycles from 8 months to seconds</span>
                      </li>
                      <li className="flex items-start gap-2">
                        <span className="mt-1 text-emerald-400">✓</span>
                        <span>Immediate access to investor capital</span>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
            </section>

            {/* Market Opportunity - Visual Size Indicators */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">
                Massive Market Opportunity
              </h2>
              <div className="grid gap-4 md:grid-cols-3">
                <div className="relative overflow-hidden rounded-xl border border-slate-200 bg-white p-5">
                  <div className="text-xs uppercase tracking-[0.2em] text-slate-600">
                    Global Market
                  </div>
                  <div className="mt-2 text-2xl font-bold text-[#7d471e]">
                    SAR 37T
                  </div>
                  <div className="mt-1 text-xs text-slate-600">
                    Annual transaction volume
                  </div>
                  <div className="absolute -right-2 -top-2 h-16 w-16 rounded-full bg-slate-800/50 blur-xl" />
                </div>
                <div className="relative overflow-hidden rounded-xl border border-slate-200 bg-white p-5">
                  <div className="text-xs uppercase tracking-[0.2em] text-slate-600">
                    GCC Market
                  </div>
                  <div className="mt-2 text-2xl font-bold text-[#7d471e]">
                    SAR 1.3T
                  </div>
                  <div className="mt-1 text-xs text-slate-600">
                    Real estate market size
                  </div>
                  <div className="absolute -right-2 -top-2 h-16 w-16 rounded-full bg-slate-800/50 blur-xl" />
                </div>
                <div className="relative overflow-hidden rounded-xl border border-emerald-200 bg-white p-5">
                  <div className="text-xs uppercase tracking-[0.2em] text-[#cda22b]">
                    Saudi Market
                  </div>
                  <div className="mt-2 text-2xl font-bold text-[#cda22b]">
                    SAR 400B
                  </div>
                  <div className="mt-1 text-xs text-[#cda22b]/70">
                    Annual transactions
                  </div>
                  <div className="absolute -right-2 -top-2 h-16 w-16 rounded-full bg-white blur-xl" />
                </div>
              </div>
              <div className="mt-4 rounded-lg border border-slate-200 bg-white p-4">
                <div className="text-xs text-slate-600">
                  <strong className="text-[#7d471e]">Market Trends:</strong> Growing
                  demand for fractional ownership models, increasing retail investor
                  participation, and shift toward digital investment platforms.
                </div>
              </div>
            </section>

            {/* Business Model */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">Business Model</h2>
              <div className="grid gap-4 md:grid-cols-3">
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <div className="mb-3 text-2xl">💰</div>
                  <div className="text-sm font-semibold text-[#7d471e]">
                    Transaction Commissions
                  </div>
                  <div className="mt-2 text-xs text-slate-600">
                    Revenue from each investment transaction
                  </div>
                </div>
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <div className="mb-3 text-2xl">📱</div>
                  <div className="text-sm font-semibold text-[#7d471e]">
                    Platform Subscriptions
                  </div>
                  <div className="mt-2 text-xs text-slate-600">
                    Recurring revenue from platform access
                  </div>
                </div>
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <div className="mb-3 text-2xl">📊</div>
                  <div className="text-sm font-semibold text-[#7d471e]">
                    Ownership Share Fees
                  </div>
                  <div className="mt-2 text-xs text-slate-600">
                    Fees from fractional ownership management
                  </div>
                </div>
              </div>
            </section>

            {/* Competitive Advantage */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">
                Competitive Advantages
              </h2>
              <div className="grid gap-4 md:grid-cols-2">
                <div className="rounded-xl border border-emerald-200 bg-white p-5">
                  <div className="mb-2 text-lg font-semibold text-[#cda22b]">
                    🏛️ Regulatory Advantage
                  </div>
                  <div className="text-sm text-[#7d471e]">
                    First licensed fractional ownership platform in Saudi Arabia.
                    Regulatory alignment with CMA and REGA.
                  </div>
                </div>
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <div className="mb-2 text-lg font-semibold text-[#7d471e]">
                    💧 Liquidity Advantage
                  </div>
                  <div className="text-sm text-[#7d471e]">
                    Built-in resale marketplace for investor exits, solving the
                    traditional real estate liquidity problem.
                  </div>
                </div>
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <div className="mb-2 text-lg font-semibold text-[#7d471e]">
                    🤖 Technology Advantage
                  </div>
                  <div className="text-sm text-[#7d471e]">
                    Fully digital investment infrastructure with AI-driven deal
                    sourcing and matching.
                  </div>
                </div>
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <div className="mb-2 text-lg font-semibold text-[#7d471e]">
                    🏢 Market Advantage
                  </div>
                  <div className="text-sm text-[#7d471e]">
                    Deep developer partnerships with ready pipeline exceeding $100M in
                    real estate assets.
                  </div>
                </div>
              </div>
            </section>

            {/* Financial Overview */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">
                Financial Overview
              </h2>
              <div className="rounded-xl border border-slate-200 bg-white p-6">
                <div className="grid gap-6 md:grid-cols-2">
                  <div>
                    <div className="text-xs uppercase tracking-[0.2em] text-slate-600">
                      Current Round
                    </div>
                    <div className="mt-3 space-y-2">
                      <div className="flex items-center justify-between">
                        <span className="text-sm text-slate-600">Pre-valuation</span>
                        <span className="text-lg font-semibold text-[#7d471e]">
                          $10M
                        </span>
                      </div>
                      <div className="flex items-center justify-between">
                        <span className="text-sm text-slate-600">Post-valuation</span>
                        <span className="text-lg font-semibold text-[#7d471e]">
                          $10.32M
                        </span>
                      </div>
                      <div className="flex items-center justify-between border-t border-slate-200 pt-2">
                        <span className="text-sm font-medium text-[#cda22b]">
                          Fundraising Ask
                        </span>
                        <span className="text-xl font-bold text-[#cda22b]">
                          $320K
                        </span>
                      </div>
                    </div>
                  </div>
                  <div>
                    <div className="text-xs uppercase tracking-[0.2em] text-slate-600">
                      Key Metrics
                    </div>
                    <div className="mt-3 grid grid-cols-2 gap-3">
                      <div>
                        <div className="text-xs text-[#7d471e]0">Revenue</div>
                        <div className="text-sm font-semibold text-[#7d471e]">
                          SAR 260K
                        </div>
                      </div>
                      <div>
                        <div className="text-xs text-[#7d471e]0">GMV</div>
                        <div className="text-sm font-semibold text-[#7d471e]">
                          SAR 4M
                        </div>
                      </div>
                      <div>
                        <div className="text-xs text-[#7d471e]0">LTV</div>
                        <div className="text-sm font-semibold text-[#7d471e]">
                          SAR 7,000
                        </div>
                      </div>
                      <div>
                        <div className="text-xs text-[#7d471e]0">CAC</div>
                        <div className="text-sm font-semibold text-[#7d471e]">
                          SAR 200
                        </div>
                      </div>
                      <div>
                        <div className="text-xs text-[#7d471e]0">Gross Margin</div>
                        <div className="text-sm font-semibold text-[#7d471e]">10%</div>
                      </div>
                      <div>
                        <div className="text-xs text-[#7d471e]0">Burn Rate</div>
                        <div className="text-sm font-semibold text-[#7d471e]">
                          SAR 100K/mo
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </section>

            {/* Growth Strategy */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">Growth Strategy</h2>
              <div className="rounded-xl border border-slate-200 bg-white p-5">
                <div className="flex items-start gap-4">
                  <div className="text-2xl">🎯</div>
                  <div className="flex-1 space-y-3">
                    <div className="text-sm text-[#7d471e]">
                      <strong className="text-[#7d471e]">Expand across GCC markets</strong>{" "}
                      to capture regional real estate investment demand
                    </div>
                    <div className="text-sm text-[#7d471e]">
                      <strong className="text-[#7d471e]">Scale investor base</strong> and
                      deal pipeline to increase platform liquidity
                    </div>
                    <div className="text-sm text-[#7d471e]">
                      <strong className="text-[#7d471e]">Reach SAR 2 billion in AUM</strong>{" "}
                      within 3 years through strategic partnerships and market expansion
                    </div>
                  </div>
                </div>
              </div>
            </section>

            {/* Investment Thesis */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">Investment Thesis</h2>
              <div className="rounded-xl border border-emerald-200 bg-white p-6">
                <div className="mb-4 text-lg font-semibold text-[#cda22b]">
                  Why Invest in Madak?
                </div>
                <div className="grid gap-3 md:grid-cols-2">
                  <div className="flex items-start gap-2">
                    <span className="mt-0.5 text-emerald-400">✓</span>
                    <span className="text-sm text-[#7d471e]">
                      Strong early traction and real revenue
                    </span>
                  </div>
                  <div className="flex items-start gap-2">
                    <span className="mt-0.5 text-emerald-400">✓</span>
                    <span className="text-sm text-[#7d471e]">
                      Licensed and regulated platform in high-growth market
                    </span>
                  </div>
                  <div className="flex items-start gap-2">
                    <span className="mt-0.5 text-emerald-400">✓</span>
                    <span className="text-sm text-[#7d471e]">
                      Proven unit economics and fast deal execution
                    </span>
                  </div>
                  <div className="flex items-start gap-2">
                    <span className="mt-0.5 text-emerald-400">✓</span>
                    <span className="text-sm text-[#7d471e]">
                      Large untapped market opportunity in Saudi and GCC
                    </span>
                  </div>
                  <div className="flex items-start gap-2 md:col-span-2">
                    <span className="mt-0.5 text-emerald-400">✓</span>
                    <span className="text-sm text-[#7d471e]">
                      Clear scalability and expansion roadmap
                    </span>
                  </div>
                </div>
              </div>
            </section>

            {/* Team */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">Founding Team</h2>
              <div className="grid gap-4 md:grid-cols-2">
                <div className="space-y-3 rounded-xl border border-slate-200 bg-white p-5">
                  <div className="flex items-center gap-3">
                    <div className="h-12 w-12 rounded-full bg-gradient-to-br from-emerald-400 to-cyan-400" />
                    <div>
                      <p className="text-sm font-semibold text-[#7d471e]">
                        Hussain Hameed Aldeen
                      </p>
                      <p className="text-xs text-slate-600">
                        Co-Founder & CEO
                      </p>
                    </div>
                  </div>
                  <p className="text-xs leading-relaxed text-[#7d471e]">
                    13+ years experience in real estate and revenue management. Investor
                    and founder experience across multiple ventures.
                  </p>
                </div>
                <div className="space-y-3 rounded-xl border border-slate-200 bg-white p-5">
                  <div className="flex items-center gap-3">
                    <div className="h-12 w-12 rounded-full bg-gradient-to-br from-cyan-400 to-sky-400" />
                    <div>
                      <p className="text-sm font-semibold text-[#7d471e]">
                        Abdulaziz Alardi
                      </p>
                      <p className="text-xs text-slate-600">
                        Co-Founder & CCO
                      </p>
                    </div>
                  </div>
                  <p className="text-xs leading-relaxed text-[#7d471e]">
                    Growth, monetization, and product-market fit specialist. Previously
                    worked at Sary, Foodics, and NUPCO. Built growth and retention
                    systems and fundraising partnerships.
                  </p>
                </div>
              </div>
            </section>

            {/* Risk & Mitigation */}
            <section className="space-y-4">
              <h2 className="text-2xl font-semibold text-[#7d471e]">
                Risk &amp; Mitigation
              </h2>
              <div className="grid gap-4 md:grid-cols-2">
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <p className="text-sm font-semibold text-[#7d471e]">Key Risks</p>
                  <ul className="mt-3 space-y-2 text-xs text-slate-600">
                    <li className="flex items-start gap-2">
                      <span>•</span>
                      <span>Regulatory changes in fractional ownership framework</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span>•</span>
                      <span>Market volatility affecting real estate valuations</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span>•</span>
                      <span>Competition from established real estate players</span>
                    </li>
                  </ul>
                </div>
                <div className="rounded-xl border border-slate-200 bg-white p-5">
                  <p className="text-sm font-semibold text-[#7d471e]">
                    Mitigation Levers
                  </p>
                  <ul className="mt-3 space-y-2 text-xs text-slate-600">
                    <li className="flex items-start gap-2">
                      <span>•</span>
                      <span>
                        Strong regulatory relationships and compliance framework
                      </span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span>•</span>
                      <span>Diversified portfolio and risk management systems</span>
                    </li>
                    <li className="flex items-start gap-2">
                      <span>•</span>
                      <span>First-mover advantage and technology moat</span>
                    </li>
                  </ul>
                </div>
              </div>
              <p className="text-xs text-[#7d471e]0">
                This summary does not constitute investment advice or an offer to
                invest. Full risk factors are available in the formal documentation.
              </p>
            </section>
          </section>

          {/* Right column – highlight card & final CTA */}
          <aside className="space-y-6 lg:sticky lg:top-10">
            <div className="rounded-3xl border border-emerald-300 bg-white p-6 shadow-[0_0_80px_rgba(16,185,129,0.12)]">
              <p className="text-xs font-semibold uppercase tracking-[0.2em] text-[#cda22b]">
                Deal Snapshot
              </p>
              <div className="mt-5 space-y-3 text-sm text-[#7d471e]">
                <div className="flex items-center justify-between">
                  <span className="text-slate-600">Pre-valuation</span>
                  <span className="font-medium text-[#7d471e]">$10M</span>
                </div>
                <div className="flex items-center justify-between">
                  <span className="text-slate-600">Post-valuation</span>
                  <span className="font-medium text-[#7d471e]">$10.32M</span>
                </div>
                <div className="flex items-center justify-between border-t border-slate-200 pt-3">
                  <span className="text-slate-600">Fundraising Ask</span>
                  <span className="text-lg font-bold text-[#cda22b]">$320K</span>
                </div>
                <div className="flex items-center justify-between">
                  <span className="text-slate-600">Status</span>
                  <span className="font-medium text-[#cda22b]">
                    Open for expressions of interest
                  </span>
                </div>
              </div>
              <a
                href={PRIMARY_WHATSAPP_INTEREST}
                target="_blank"
                rel="noopener noreferrer"
                className="mt-6 inline-flex w-full items-center justify-center rounded-full bg-emerald-600 px-6 py-2.5 text-sm font-semibold text-white shadow-md shadow-emerald-400/40 transition hover:bg-emerald-700"
              >
                Express Interest via WhatsApp
              </a>
              <p className="mt-3 text-[11px] leading-relaxed text-[#7d471e]0">
                You will be redirected to WhatsApp to connect directly with the
                Finjan.vc team and receive full details on this opportunity.
              </p>
            </div>

            {/* Final Call To Action */}
            <div className="rounded-3xl border border-slate-200 bg-white/80 p-6">
              <h2 className="text-lg font-semibold text-[#7d471e]">
                Connect with Finjan.vc
              </h2>
              <p className="mt-2 text-sm text-[#7d471e]">
                For access to the full investment pack, data room, and detailed
                terms, reach out to the team.
              </p>
              <div className="mt-4 space-y-3 text-sm">
                <a
                  href={FINJAN_WHATSAPP}
                  target="_blank"
                  rel="noopener noreferrer"
                  className="inline-flex w-full items-center justify-center rounded-full border border-emerald-300 bg-white px-6 py-2.5 text-sm font-semibold text-[#cda22b] transition hover:bg-white"
                >
                  Connect With Us
                </a>
                <div className="space-y-1 text-xs text-[#7d471e]">
                  <p>
                    Website:{" "}
                    <Link
                      href="https://www.finjan.vc"
                      className="text-[#cda22b] underline underline-offset-4"
                    >
                      www.Finjan.vc
                    </Link>
                  </p>
                  <p>
                    Email:{" "}
                    <a
                      href="mailto:info@finjan.vc"
                      className="text-[#cda22b] underline underline-offset-4"
                    >
                      info@finjan.vc
                    </a>
                  </p>
                </div>
              </div>
              <p className="mt-4 text-[11px] text-[#7d471e]0">
                This material is for informational purposes only and does not
                constitute an offer to sell or a solicitation of an offer to buy any
                securities. Any investment decision should be made based on formal
                offering documentation.
              </p>
            </div>
          </aside>
        </main>
      </div>
    </div>
  );
}
