import { Suspense } from "react";
import InvestmentLanding from "./opportunity/InvestmentLanding";

type HomeProps = {
  searchParams?: { ref?: string };
};

export default function Home({ searchParams }: HomeProps) {
  const ref = searchParams?.ref;

  return (
    <Suspense fallback={<div className="min-h-screen bg-slate-950" />}>
      <InvestmentLanding refCode={ref ?? null} />
    </Suspense>
  );
}
